<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ExamAttempt extends Model
{
    protected $table = 'exam_attempts';
    protected $primaryKey = 'Attempt_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Course_id',
        'Score',
        'Total_questions',
        'Pass_threshold',
        'Is_passed',
        'Is_completed', // Added
        'Attempted_at',
        'Type',
        'Interview_id',
    ];

    protected $casts = [
        'Score' => 'float',
        'Total_questions' => 'integer',
        'Pass_threshold' => 'integer',
        'Is_passed' => 'boolean',
        'Is_completed' => 'boolean', // Added
        'Attempted_at' => 'datetime',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Type' => 'string',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }

    public function userCourse(): BelongsTo
    {
        return $this->belongsTo(UserCourse::class, 'User_id', 'User_id');
    }

    public function interviewAttempt(): BelongsTo
    {
        return $this->belongsTo(InterviewAttempt::class, 'Interview_id', 'Interview_id');
    }
}
